/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ControllableDrawerTile<T extends ControllableDrawerTile<T>>
extends ActiveTile<T> {
    private boolean needsUpgradeCache = true;
    @Save
    private BlockPos controllerPos;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> storageUpgrades;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> utilityUpgrades;
    @Save
    private DrawerOptions drawerOptions = new DrawerOptions();
    @Save
    private boolean hasDowngrade = false;
    @Save
    private boolean isCreative = false;
    @Save
    private boolean isVoid = false;
    @Save
    private int mult = 1;

    public ControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
        this.storageUpgrades = this.getStorageUpgradesConstructor();
        if (this.getStorageSlotAmount() > 0) {
            this.addInventory(this.storageUpgrades);
        }
        this.utilityUpgrades = new InventoryComponent("utility_upgrades", 114, 70, 3).setInputFilter((stack, integer) -> stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).getType() == UpgradeItem.Type.UTILITY).setSlotLimit(1).setOnSlotChanged((itemStack, integer) -> {
            BlockEntity patt3167$temp;
            this.needsUpgradeCache = true;
            if (this.controllerPos != null && (patt3167$temp = this.f_58857_.m_7702_(this.controllerPos)) instanceof DrawerControllerTile) {
                DrawerControllerTile controllerTile = (DrawerControllerTile)patt3167$temp;
                controllerTile.getConnectedDrawers().rebuild();
            }
        });
        this.addInventory(this.utilityUpgrades);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        if (this.getStorageSlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon("Storage", 10, 59, false, ChatFormatting.DARK_GRAY.m_126665_()){

                public String getText() {
                    return new TranslatableComponent("key.categories.storage").getString();
                }
            });
        }
        this.addGuiAddonFactory(() -> new TextScreenAddon("Utility", 114, 59, false, ChatFormatting.DARK_GRAY.m_126665_()){

            public String getText() {
                return new TranslatableComponent("key.categories.utility").getString();
            }
        });
        this.addGuiAddonFactory(() -> new TextScreenAddon("key.categories.inventory", 8, 92, false, ChatFormatting.DARK_GRAY.m_126665_()){

            public String getText() {
                return new TranslatableComponent("key.categories.inventory").getString();
            }
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (level.m_46467_() % 20L == 0L) {
            for (int i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                Item item;
                ItemStack stack = this.utilityUpgrades.getStackInSlot(i);
                if (stack.m_41619_() || !(item = stack.m_41720_()).equals(FunctionalStorage.REDSTONE_UPGRADE.get())) continue;
                level.m_46672_(this.m_58899_(), (Block)this.getBasicTileBlock());
                break;
            }
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        if (this.controllerPos != null) {
            TileUtil.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.controllerPos, DrawerControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, this.m_58899_()));
        }
        this.controllerPos = controllerPos;
    }

    public int getStorageMultiplier() {
        this.maybeCacheUpgrades();
        return this.mult;
    }

    public boolean isVoid() {
        this.maybeCacheUpgrades();
        return this.isVoid;
    }

    public boolean isCreative() {
        this.maybeCacheUpgrades();
        return this.isCreative;
    }

    public double getStorageDiv() {
        return 1.0;
    }

    public void setNeedsUpgradeCache(boolean needsUpgradeCache) {
        this.needsUpgradeCache = needsUpgradeCache;
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        Item item;
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeItem instanceof StorageUpgradeItem) {
                int i;
                StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)upgradeItem;
                InventoryComponent<ControllableDrawerTile<T>> component = this.storageUpgrades;
                for (i = 0; i < component.getSlots(); ++i) {
                    if (!component.getStackInSlot(i).m_41619_()) continue;
                    playerIn.m_21008_(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
                for (i = 0; i < component.getSlots(); ++i) {
                    StorageUpgradeItem instertedUpgrade;
                    Item item2;
                    if (component.getStackInSlot(i).m_41619_() || !((item2 = component.getStackInSlot(i).m_41720_()) instanceof StorageUpgradeItem) || (instertedUpgrade = (StorageUpgradeItem)item2).getStorageMultiplier() >= storageUpgradeItem.getStorageMultiplier()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)component.getStackInSlot(i).m_41777_());
                    ItemStack upgradeStack = stack.m_41777_();
                    upgradeStack.m_41764_(1);
                    component.setStackInSlot(i, upgradeStack);
                    stack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
            } else {
                InventoryComponent<ControllableDrawerTile<T>> component = this.utilityUpgrades;
                for (int i = 0; i < component.getSlots(); ++i) {
                    if (!component.getStackInSlot(i).m_41619_()) continue;
                    playerIn.m_21008_(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot == -1) {
            this.openGui(playerIn);
        }
        return InteractionResult.SUCCESS;
    }

    public abstract int getStorageSlotAmount();

    public void onClicked(Player playerIn, int slot) {
    }

    public abstract int getBaseSize(int var1);

    private void maybeCacheUpgrades() {
        if (this.needsUpgradeCache) {
            int i;
            this.isCreative = false;
            this.hasDowngrade = false;
            this.mult = 1;
            for (i = 0; i < this.storageUpgrades.getSlots(); ++i) {
                Item upgrade = this.storageUpgrades.getStackInSlot(i).m_41720_();
                if (upgrade.equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                    this.hasDowngrade = true;
                }
                if (upgrade.equals(FunctionalStorage.CREATIVE_UPGRADE.get())) {
                    this.isCreative = true;
                }
                if (!(upgrade instanceof StorageUpgradeItem)) continue;
                double calculated = (double)((StorageUpgradeItem)upgrade).getStorageMultiplier() / this.getStorageDiv();
                this.mult = (int)((double)this.mult * calculated);
            }
            this.isVoid = false;
            for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                if (!this.utilityUpgrades.getStackInSlot(i).m_41720_().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
            this.needsUpgradeCache = false;
        }
    }

    public boolean hasDowngrade() {
        this.maybeCacheUpgrades();
        return this.hasDowngrade;
    }

    public void toggleLocking() {
        this.setLocked(!this.isLocked());
    }

    public boolean isLocked() {
        return this.m_58900_().m_61138_((Property)DrawerBlock.LOCKED) && (Boolean)this.m_58900_().m_61143_((Property)DrawerBlock.LOCKED) != false;
    }

    public void setLocked(boolean locked) {
        if (this.m_58900_().m_61138_((Property)DrawerBlock.LOCKED)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(locked)), 3);
        }
    }

    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        this.drawerOptions.setActive(action, !this.drawerOptions.isActive(action));
        this.markForUpdate();
    }

    public DrawerOptions getDrawerOptions() {
        return this.drawerOptions;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getUtilityUpgrades() {
        return this.utilityUpgrades;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgrades() {
        return this.storageUpgrades;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public abstract InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor();

    public static class DrawerOptions
    implements INBTSerializable<CompoundTag> {
        public HashMap<ConfigurationToolItem.ConfigurationAction, Boolean> options = new HashMap();

        public DrawerOptions() {
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES, true);
        }

        public boolean isActive(ConfigurationToolItem.ConfigurationAction configurationAction) {
            return this.options.getOrDefault((Object)configurationAction, true);
        }

        public void setActive(ConfigurationToolItem.ConfigurationAction configurationAction, boolean active) {
            this.options.put(configurationAction, active);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            for (ConfigurationToolItem.ConfigurationAction action : this.options.keySet()) {
                compoundTag.m_128379_(action.name(), this.options.get((Object)action).booleanValue());
            }
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            for (String allKey : nbt.m_128431_()) {
                this.options.put(ConfigurationToolItem.ConfigurationAction.valueOf(allKey), nbt.m_128471_(allKey));
            }
        }
    }
}

